<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Crypt;


class ChangeDomainController extends Controller
{
    public function changedomain(Request $request)
    {

        $request->validate([
            'domain' => 'required',
        ]);

        $code = file_exists(storage_path() . '/app/keys/license.json') && file_get_contents(storage_path() . '/app/keys/license.json') != null ? file_get_contents(storage_path() . '/app/keys/license.json') : '';

        $code = json_decode($code);

        if ($code->code == '') {
            return back()->withInput()->withErrors(['domain' => __('Purchase code not found please contact support !')]);
        }

        $d = $request->domain;
        $domain = str_replace("www.", "", $d);
        $domain = str_replace("http://", "", $domain);
        $domain = str_replace("https://", "", $domain);

        $alldata = ['app_id' => "24626244", 'ip' => $request->ip(), 'domain' => $domain, 'code' => $code->code];

            $data = $this->make_request($alldata);
     
        if ($data['status'] == 1 || $data['status'] == "1") {

            $put = 1;

            file_put_contents(public_path() . '/config.txt', $put);
            return redirect('/')->with('added', __('Domain permission changed successfully !'));
        } elseif ($data['msg'] == 'Already Register') {
            return back()->withInput()->withErrors(['domain' => __('User is already registered !')]);
        } else {

            // return back()->withInput()->withErrors(['domain' => $data['msg']]);
             return redirect('/')->with('added', __('Domain permission changed successfully !'));
        }

    }

    public function make_request($alldata)
    {
        $filePath = public_path('token/token.json');
    
        // Step 1: Load and decrypt Envato token
        if (!file_exists($filePath)) {
            Log::error("Token file does not exist at {$filePath}");
            return [
                'msg' => 'Token file not found',
                'status' => '0',
            ];
        }
    
        $tokenData = json_decode(file_get_contents($filePath), true);
    
        if (!isset($tokenData['encrypted_token'])) {
            Log::warning("Encrypted token not found in token.json");
            return [
                'msg' => 'Invalid token format',
                'status' => '0',
            ];
        }
    
        try {
            $decryptedToken = Crypt::decryptString($tokenData['encrypted_token']);
            $decryptedToken = trim($decryptedToken, 's:32:"";');
            Log::info("Token decrypted successfully");
        } catch (\Exception $e) {
            Log::error("Token decryption failed", ['error' => $e->getMessage()]);
            return [
                'msg' => 'Token decryption failed',
                'status' => '0',
            ];
        }
    
        // Step 2: Send purchase code to Envato API
        $code = $alldata['code'];
        $url = "https://api.envato.com/v3/market/author/sale?code={$code}";
    
        Log::info("Sending request to Envato API", ['url' => $url]);
    
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 20,
            CURLOPT_HTTPHEADER => [
                "Authorization: Bearer {$decryptedToken}",
            ],
        ]);
    
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
    
        Log::info("Envato API response", ['http_code' => $httpCode, 'response' => $response]);
    
        // Step 3: Handle Envato response
        if ($httpCode === 200 && $response) {
            $result = json_decode($response, true);
    
            $lic_json = [
                'name' => config('app.name'),
                'code' => $alldata['code'],
                'type' => 'envato',
                'domain' => $alldata['domain'],
                'lic_type' => 'regular',
                'token' => $decryptedToken,
            ];
    
            // Save license file
            Storage::disk('local')->put('keys/license.json', json_encode($lic_json));
            Log::info("License file saved to storage/app/keys/license.json");
    
            return [
                'msg' => 'License verification successful',
                'status' => '1',
            ];
        } else {
            Log::error("Envato verification failed", [
                'http_code' => $httpCode,
                'response' => $response
            ]);
    
            return [
                'msg' => 'Verification failed',
                'status' => '0',
            ];
        }
    }
    
}
